/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.ghn.service.persistence;

import java.io.File;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import org.gcube.common.ghn.service.persistence.PersistenceManager;
import org.gcube.common.ghn.service.utils.Utils;

@XmlRootElement(name="local-persistence")
public class DefaultPersistenceManager
implements PersistenceManager {
    @XmlAttribute(name="location")
    private String location;

    public DefaultPersistenceManager() {
    }

    public DefaultPersistenceManager(String location) {
        this.location = location;
    }

    @Override
    public String location() {
        return this.location;
    }

    @Override
    public File file(String path) {
        Utils.notNull("relative path", path);
        return new File(this.location, path);
    }

    void afterUnmarshal(Unmarshaller u, Object parent) {
        if (this.location == null) {
            this.useDefaultLocation();
        }
    }

    private void useDefaultLocation() {
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.location == null ? 0 : this.location.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DefaultPersistenceManager other = (DefaultPersistenceManager)obj;
        return !(this.location == null ? other.location != null : !this.location.equals(other.location));
    }
}

