/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.ghn.service.handlers.request;

import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.namespace.QName;
import org.gcube.common.ghn.service.events.RequestEvent;
import org.gcube.common.ghn.service.handlers.Pipeline;
import org.gcube.common.ghn.service.handlers.RequestHandler;
import org.gcube.common.resources.gcore.GCoreEndpoint;
import org.gcube.common.scope.api.ScopeProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlRootElement(name="scope-management")
public class ScopeHandler
extends RequestHandler {
    protected static final String SCOPE_NS = "http://gcube-system.org/namespaces/scope";
    protected static final String SCOPE_HEADER_NAME = "scope";
    protected static final QName SCOPE_QNAME = new QName("http://gcube-system.org/namespaces/scope", "scope");
    private static Logger log = LoggerFactory.getLogger(ScopeHandler.class);

    @Override
    public String name() {
        return "scope-handler";
    }

    @Override
    public void handleRequest(Pipeline<RequestHandler> pipeline, RequestEvent event) {
        String scope = this.scopeFromHttpHeader(event);
        GCoreEndpoint endpoint = pipeline.context().properties().lookup("endpoint-profile").value(GCoreEndpoint.class);
        this.valid(endpoint, scope);
        log.trace("extracted scope {} from request {} to application {}", new Object[]{scope, event.uri(), pipeline.appName()});
        ScopeProvider.instance.set(scope);
        pipeline.forward(event);
    }

    private String scopeFromHttpHeader(RequestEvent e) {
        String scope = e.request().getHeader("Gcube-Scope");
        if (scope == null) {
            throw new RuntimeException("call to " + e.uri() + " is unscoped");
        }
        return scope;
    }

    private void valid(GCoreEndpoint endpoint, String scope) {
    }
}

