/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.ghn.service.handlers.lifetime;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.bind.annotation.XmlRootElement;
import org.gcube.common.ghn.service.ServiceContext;
import org.gcube.common.ghn.service.configuration.Mode;
import org.gcube.common.ghn.service.configuration.ServiceConfiguration;
import org.gcube.common.ghn.service.events.StartServiceEvent;
import org.gcube.common.ghn.service.handlers.LifetimeHandler;
import org.gcube.common.ghn.service.handlers.Pipeline;
import org.gcube.common.ghn.service.handlers.Property;
import org.gcube.common.ghn.service.utils.Utils;
import org.gcube.common.resources.gcore.GCoreEndpoint;
import org.gcube.common.resources.gcore.Resource;
import org.gcube.common.resources.gcore.Resources;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.informationsystem.publisher.RegistryPublisher;
import org.gcube.informationsystem.publisher.RegistryPublisherFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlRootElement(name="publishing-services")
public class PublishingHandler
extends LifetimeHandler {
    Logger log = LoggerFactory.getLogger(PublishingHandler.class);
    private RegistryPublisher registryPublisher = RegistryPublisherFactory.create();
    private GCoreEndpoint endpoint;
    private ServiceContext context;

    public void registryPublisher(RegistryPublisher registryPublisher) {
        this.registryPublisher = registryPublisher;
    }

    @Override
    public String name() {
        return "endpoint-publisher-handler";
    }

    @Override
    public void onStart(Pipeline<LifetimeHandler> pipeline, StartServiceEvent e) {
        this.context = pipeline.context();
        this.endpoint = this.createOrRetrieveProfile();
        this.endpoint.profile().deploymentData().status(this.context.lifecycle().state().remoteForm());
        this.storeProfile();
        pipeline.context().properties().add(new Property("endpoint-profile", this.endpoint));
        this.publishProfile(this.context.configuration(), this.endpoint);
        pipeline.forward(e);
    }

    private void publishProfile(ServiceConfiguration configuration, GCoreEndpoint endpoint) {
        for (String scope : configuration.deployment().startScopes()) {
            ScopeProvider.instance.set(scope);
            if (configuration.mode() == Mode.online) {
                endpoint = (GCoreEndpoint)this.registryPublisher.create((Resource)endpoint);
            }
            this.log.info("published endpoint profile of {} in scope {}", (Object)configuration.coordinates().name(), (Object)scope);
        }
    }

    private GCoreEndpoint createOrRetrieveProfile() {
        try {
            File file = this.context.configuration().persistenceManager().file("endpoint.xml");
            return file.exists() ? this.loadProfile(file) : this.createProfile();
        }
        catch (Exception e) {
            throw new RuntimeException("cannot store endpoint profile for " + this.context.serviceName(), e);
        }
    }

    private GCoreEndpoint createProfile() {
        this.log.info("creating endpoint profile for {}", (Object)this.context.serviceName());
        this.endpoint = Utils.getEndpointResource(this.context.configuration().coordinates());
        return this.endpoint;
    }

    private GCoreEndpoint loadProfile(File file) throws FileNotFoundException {
        this.log.info("retrieving endpoint profile for {} from {}", (Object)this.context.serviceName(), (Object)file.getAbsolutePath());
        return (GCoreEndpoint)Resources.unmarshal(GCoreEndpoint.class, (InputStream)new FileInputStream(file));
    }

    private void storeProfile() {
        File file = this.context.persistence().file("endpoint.xml");
        try {
            this.log.info("storing endpoint profile for {} from {}", (Object)this.context.serviceName(), (Object)file.getAbsolutePath());
            Resources.marshal((Object)this.endpoint, (OutputStream)new FileOutputStream(file));
        }
        catch (Exception e) {
            throw new RuntimeException("cannot store endpoint profile for " + this.context.serviceName() + " in " + file.getAbsolutePath());
        }
    }
}

