/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.ghn.service.events;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.gcube.common.ghn.service.events.ServiceEvent;
import org.gcube.common.ghn.service.handlers.RequestHandler;

public class RequestEvent
implements ServiceEvent<RequestHandler> {
    private final String servletName;
    private final HttpServletRequest request;
    private ServletContext ctx;

    public RequestEvent(String servletName, HttpServletRequest request, ServletContext ctx) {
        this.request = request;
        this.servletName = servletName;
        this.ctx = ctx;
    }

    public String servletName() {
        return this.servletName;
    }

    public ServletContext servletContext() {
        return this.ctx;
    }

    public String uri() {
        String query = this.request().getQueryString();
        return query == null ? this.request().getRequestURI() : String.valueOf(this.request().getRequestURI()) + "?" + query;
    }

    public HttpServletRequest request() {
        return this.request;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "[req=" + this.request.getRemoteHost() + "]";
    }
}

