/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.ghn.service.configuration;

import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.ServiceLoader;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import org.gcube.common.ghn.service.configuration.LifecycleConfiguration;
import org.gcube.common.ghn.service.handlers.ServiceHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LifecycleConfigurationBinder {
    private static final Logger log = LoggerFactory.getLogger(LifecycleConfiguration.class);

    public LifecycleConfiguration bind(InputStream stream) {
        Set<Class<?>> classes = this.scanForConfigurationElements();
        try {
            JAXBContext ctx = JAXBContext.newInstance((Class[])classes.toArray(new Class[0]));
            return (LifecycleConfiguration)ctx.createUnmarshaller().unmarshal(stream);
        }
        catch (JAXBException e) {
            throw new RuntimeException("invalid service configuration", e);
        }
    }

    public String bind(LifecycleConfiguration config) {
        try {
            ArrayList classes = new ArrayList();
            classes.add(LifecycleConfiguration.class);
            for (ServiceHandler serviceHandler : config.lifetimeHandlers()) {
                classes.add(serviceHandler.getClass());
            }
            for (ServiceHandler serviceHandler : config.requestHandlers()) {
                classes.add(serviceHandler.getClass());
            }
            JAXBContext jAXBContext = JAXBContext.newInstance((Class[])classes.toArray(new Class[0]));
            StringWriter writer = new StringWriter();
            jAXBContext.createMarshaller().marshal((Object)config, (Writer)writer);
            return writer.toString();
        }
        catch (JAXBException e) {
            throw new RuntimeException("invalid service configuration", e);
        }
    }

    private Set<Class<?>> scanForConfigurationElements() throws RuntimeException {
        ServiceLoader<ServiceHandler> handlerLoader = ServiceLoader.load(ServiceHandler.class);
        HashSet scanned = new HashSet();
        for (ServiceHandler handler : handlerLoader) {
            Class<?> handlerClass = handler.getClass();
            if (handlerClass.isInterface() || handlerClass.getModifiers() == 1024) continue;
            scanned.add(handlerClass);
        }
        log.debug("found the following service handlers: {}", scanned);
        scanned.add(LifecycleConfiguration.class);
        return scanned;
    }
}

