/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.ghn.service.configuration;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.gcube.common.ghn.service.configuration.LifetimeHandlerAdapter;
import org.gcube.common.ghn.service.configuration.RequestHandlerAdapter;
import org.gcube.common.ghn.service.handlers.LifetimeHandler;
import org.gcube.common.ghn.service.handlers.RequestHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlRootElement(name="service-lifecycle")
public class LifecycleConfiguration {
    private static Logger log = LoggerFactory.getLogger(LifecycleConfiguration.class);
    @XmlElement(name="lifetime-handlers")
    private LifetimeHandlers lifetimeHandlers = new LifetimeHandlers();
    @XmlElement(name="request-handlers")
    private RequestHandlers requestHandlers = new RequestHandlers();

    public List<LifetimeHandler> lifetimeHandlers() {
        return this.lifetimeHandlers.values;
    }

    public LifecycleConfiguration lifetimeHandlers(LifetimeHandler ... handlers) {
        this.lifetimeHandlers = new LifetimeHandlers(Arrays.asList(handlers));
        return this;
    }

    public List<RequestHandler> requestHandlers() {
        return this.requestHandlers.values;
    }

    public LifecycleConfiguration requestHandlers(RequestHandler ... handlers) {
        this.requestHandlers = new RequestHandlers(Arrays.asList(handlers));
        return this;
    }

    void afterUnmarshal(Unmarshaller u, Object parent) {
        ArrayList<LifetimeHandler> ltHandlers = new ArrayList<LifetimeHandler>(this.lifetimeHandlers.values);
        for (LifetimeHandler handler : ltHandlers) {
            if (!(handler instanceof LifetimeHandlerAdapter.UnavailableHandler)) continue;
            log.error("lifetime handler {} is configured but not installed", (Object)handler);
            this.lifetimeHandlers.values.remove(handler);
        }
        ArrayList<RequestHandler> rqHandlers = new ArrayList<RequestHandler>(this.requestHandlers.values);
        for (RequestHandler handler : rqHandlers) {
            if (!(handler instanceof RequestHandlerAdapter.UnavailableHandler)) continue;
            log.error("request handler {} is configured but not installed", (Object)handler);
            this.requestHandlers.values.remove(handler);
        }
    }

    private static class LifetimeHandlers {
        @XmlAnyElement(lax=true)
        List<LifetimeHandler> values = new ArrayList<LifetimeHandler>();

        LifetimeHandlers() {
        }

        LifetimeHandlers(List<LifetimeHandler> handlers) {
            this.values = handlers;
        }
    }

    private static class RequestHandlers {
        @XmlAnyElement(lax=true)
        List<RequestHandler> values = new ArrayList<RequestHandler>();

        RequestHandlers() {
        }

        RequestHandlers(List<RequestHandler> handlers) {
            this.values = handlers;
        }
    }
}

