/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.ghn.service;

import org.gcube.common.events.Hub;
import org.gcube.common.events.impl.DefaultHub;
import org.gcube.common.ghn.service.configuration.ServiceConfiguration;
import org.gcube.common.ghn.service.handlers.Properties;
import org.gcube.common.ghn.service.lifetime.DefaultLifecycle;
import org.gcube.common.ghn.service.lifetime.Lifecycle;
import org.gcube.common.ghn.service.persistence.PersistenceManager;

public class ServiceContext {
    private final ServiceConfiguration configuration;
    private final Properties properties;
    private final Hub hub;
    private final Lifecycle lifecycle;

    public ServiceContext(ServiceConfiguration configuration) {
        this.configuration = configuration;
        this.hub = new DefaultHub();
        this.lifecycle = new DefaultLifecycle(this.hub, configuration.coordinates().name());
        this.properties = new Properties();
    }

    public ServiceContext(ServiceConfiguration configuration, Lifecycle lifecycle, Hub hub, Properties properties) {
        this.configuration = configuration;
        this.lifecycle = lifecycle;
        this.properties = properties;
        this.hub = hub;
    }

    public ServiceContext(ServiceContext context) {
        this(context.configuration(), context.lifecycle, context.hub(), new Properties(context.properties()));
    }

    public PersistenceManager persistence() {
        return this.configuration.persistenceManager();
    }

    public String serviceName() {
        return this.configuration.coordinates().name();
    }

    public ServiceConfiguration configuration() {
        return this.configuration;
    }

    public Properties properties() {
        return this.properties;
    }

    public Lifecycle lifecycle() {
        return this.lifecycle;
    }

    public Hub hub() {
        return this.hub;
    }
}

