/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.ghn.service;

import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.annotation.WebListener;
import org.gcube.common.ghn.service.ServiceManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebListener
public class LifetimeListener
implements ServletContextListener {
    private static Logger log = LoggerFactory.getLogger(LifetimeListener.class);
    private ServiceManager manager;
    private static final String init_flag = "app-initialized";

    public void contextInitialized(ServletContextEvent sce) {
        ServletContext ctx = sce.getServletContext();
        if (ctx.getAttribute(init_flag) != null) {
            return;
        }
        this.manager = new ServiceManager();
        try {
            log.info("managing application @ {} as a gCube service", (Object)ctx.getContextPath());
            this.manager.start(ctx);
        }
        catch (Throwable t) {
            log.error("cannot manage application @ " + ctx.getContextPath() + " as a gCube service ", t);
        }
        ctx.setAttribute(init_flag, (Object)true);
    }

    public void contextDestroyed(ServletContextEvent sce) {
        if (this.manager == null) {
            return;
        }
        ServletContext ctx = sce.getServletContext();
        try {
            log.info("stopping management of application @ {} as a gCube service", (Object)ctx.getContextPath());
            this.manager.stop(ctx);
        }
        catch (Throwable t) {
            log.error("cannot stop management of application @ {} as a gCube service", (Object)ctx.getContextPath());
        }
    }
}

