/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.ghn.service.utils;

import java.net.InetAddress;
import java.util.Calendar;
import org.gcube.common.ghn.service.configuration.Coordinates;
import org.gcube.common.resources.gcore.GCoreEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils {
    private static Logger logger = LoggerFactory.getLogger(Utils.class);

    public static GCoreEndpoint getEndpointResource(Coordinates coordinate) {
        GCoreEndpoint instance = new GCoreEndpoint();
        instance.profile().description(coordinate.description()).serviceName(coordinate.name()).serviceClass(coordinate.serviceClass()).version(coordinate.version()).serviceId(String.valueOf(coordinate.name()) + coordinate.serviceClass() + coordinate.version());
        instance.profile().newDeploymentData().activationTime(Calendar.getInstance()).status("READY");
        try {
            instance.profile().ghnId(InetAddress.getLocalHost().getHostAddress());
        }
        catch (Exception e) {
            logger.warn("problem discovering localhost address", (Throwable)e);
            instance.profile().ghnId("fakeId");
        }
        return instance;
    }

    public static void valid(String name, Object[] o) throws IllegalArgumentException {
        Utils.notNull(name, o);
    }

    public static void notNull(Object[] o) throws IllegalArgumentException {
        Utils.notNull("argument", o);
    }

    public static void notNull(String name, Object o) throws IllegalArgumentException {
        if (o == null) {
            throw new IllegalArgumentException(String.valueOf(name) + " is null");
        }
    }

    public static void notEmpty(String name, String o) throws IllegalArgumentException {
        if (o.isEmpty()) {
            throw new IllegalArgumentException(String.valueOf(name) + " is empty");
        }
    }

    public static void notEmpty(String name, Object[] o) throws IllegalArgumentException {
        if (o.length == 0) {
            throw new IllegalArgumentException(String.valueOf(name) + " is empty");
        }
    }

    public static void valid(String name, String o) throws IllegalArgumentException {
        Utils.notNull(name, o);
        Utils.notEmpty(name, o);
    }
}

