/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.ghn.service.lifetime;

import org.gcube.common.events.Hub;
import org.gcube.common.ghn.service.lifetime.Lifecycle;
import org.gcube.common.ghn.service.lifetime.State;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultLifecycle
implements Lifecycle {
    private static final Logger log = LoggerFactory.getLogger(Lifecycle.class);
    private final Hub hub;
    private final String serviceName;
    private State currentState;
    private State previousState;

    public DefaultLifecycle(Hub hub, String serviceName) {
        this.hub = hub;
        this.currentState = State.started;
        this.serviceName = serviceName;
    }

    @Override
    public State state() {
        return this.currentState;
    }

    @Override
    public void moveTo(State next) {
        if (next == this.currentState) {
            return;
        }
        if (!this.currentState.next().contains((Object)next)) {
            throw new IllegalStateException("cannot transition service " + this.serviceName + " from " + (Object)((Object)this.currentState) + " to " + (Object)((Object)next));
        }
        this.previousState = this.currentState;
        this.currentState = next;
        log.info("service {} transitioned from {} to {}", new Object[]{this.serviceName, this.previousState, this.currentState});
        this.hub.fire((Object)this, new String[]{this.currentState.event()});
    }

    @Override
    public void tryMoveTo(State next) {
        try {
            this.moveTo(next);
        }
        catch (IllegalStateException ignore) {
            log.warn(ignore.getMessage());
        }
    }

    @Override
    public State previous() {
        return this.previousState;
    }
}

