/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.ghn.service.handlers;

import java.util.ArrayList;
import java.util.List;
import org.gcube.common.ghn.service.ServiceContext;
import org.gcube.common.ghn.service.events.ServiceEvent;
import org.gcube.common.ghn.service.handlers.Pipeline;
import org.gcube.common.ghn.service.handlers.ServiceHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPipeline<T extends ServiceHandler<T>>
implements Pipeline<T> {
    private static Logger log = LoggerFactory.getLogger(DefaultPipeline.class);
    private final List<T> handlers;
    private final ServiceContext context;
    private int cursor = 0;

    public DefaultPipeline(List<T> handlers, ServiceContext context) {
        this.handlers = new ArrayList<T>(handlers);
        this.context = context;
    }

    @Override
    public ServiceContext context() {
        return this.context;
    }

    @Override
    public String appName() {
        return this.context.configuration().coordinates().name();
    }

    @Override
    public List<T> handlers() {
        return new ArrayList<T>(this.handlers);
    }

    @Override
    public void forward(ServiceEvent<T> e) {
        if (this.cursor >= this.handlers.size()) {
            return;
        }
        ServiceHandler handler = (ServiceHandler)this.handlers.get(this.cursor);
        ++this.cursor;
        log.trace("forwarding {} to {}", e, (Object)handler.name());
        handler.onEvent(this, e);
    }
}

