/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.ghn.service;

import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterRegistration;
import javax.servlet.ServletContext;
import javax.servlet.ServletRegistration;
import org.gcube.common.ghn.service.RequestFilter;
import org.gcube.common.ghn.service.ServiceContext;
import org.gcube.common.ghn.service.configuration.LifecycleConfiguration;
import org.gcube.common.ghn.service.configuration.LifecycleConfigurationBinder;
import org.gcube.common.ghn.service.configuration.ServiceConfiguration;
import org.gcube.common.ghn.service.configuration.ServiceConfigurationBinder;
import org.gcube.common.ghn.service.events.StartServiceEvent;
import org.gcube.common.ghn.service.events.StopServiceEvent;
import org.gcube.common.ghn.service.extensions.ServiceLifetime;
import org.gcube.common.ghn.service.handlers.DefaultPipeline;
import org.gcube.common.ghn.service.handlers.LifetimeHandler;
import org.gcube.common.ghn.service.handlers.Pipeline;
import org.gcube.common.ghn.service.handlers.RequestHandler;
import org.gcube.common.ghn.service.lifetime.State;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceManager {
    private static Logger log = LoggerFactory.getLogger(ServiceManager.class);
    private Pipeline<LifetimeHandler> ltPipeline;
    private ServiceContext context;

    public void start(ServletContext ctx) throws RuntimeException {
        ServiceConfiguration configuration = this.readConfiguration(ctx);
        LifecycleConfiguration lifecycleConfiguration = this.readLifecycleConfiguration(ctx);
        this.context = new ServiceContext(configuration);
        try {
            this.startLifetimeHandlers(ctx, lifecycleConfiguration);
            this.registerRequestHandlers(ctx, lifecycleConfiguration);
            this.registerManagementServlet(ctx);
            this.context.lifecycle().moveTo(State.ready);
        }
        catch (RuntimeException e) {
            this.context.lifecycle().moveTo(State.failed);
            throw e;
        }
    }

    public void stop(ServletContext ctx) {
        if (this.context == null) {
            return;
        }
        this.stopLifetimeHandlers(ctx);
        this.context.lifecycle().tryMoveTo(State.stopped);
    }

    private ServiceConfiguration readConfiguration(ServletContext ctx) {
        try {
            ServiceConfigurationBinder binder = new ServiceConfigurationBinder();
            return binder.bind(ctx.getResourceAsStream("/WEB-INF/gcube-service.xml"));
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    private LifecycleConfiguration readLifecycleConfiguration(ServletContext ctx) {
        InputStream config = ctx.getResourceAsStream("/WEB-INF/gcube-service-lifecycle.xml");
        if (config == null) {
            log.info("using default lifecycle as the application does not include {}", (Object)"/WEB-INF/gcube-service-lifecycle.xml");
            config = this.getClass().getResourceAsStream("/META-INF/default-lifecycle.xml");
            if (config == null) {
                throw new IllegalStateException("invalid library distribution: cannot find /META-INF/default-lifecycle.xml");
            }
        } else {
            log.info("using custom lifecycle configuration @ {}", (Object)"/WEB-INF/gcube-service-lifecycle.xml");
        }
        LifecycleConfigurationBinder binder = new LifecycleConfigurationBinder();
        return binder.bind(config);
    }

    private void registerRequestHandlers(ServletContext ctx, LifecycleConfiguration configuration) {
        List<RequestHandler> rqHandlers = configuration.requestHandlers();
        DefaultPipeline<RequestHandler> rqPipelineTemplate = new DefaultPipeline<RequestHandler>(rqHandlers, this.context);
        Collection servlets = ctx.getServletRegistrations().values();
        for (ServletRegistration servlet : servlets) {
            String name = servlet.getName();
            if (name.equals("default") || name.equals("jsp")) continue;
            for (String mapping : servlet.getMappings()) {
                RequestFilter requestFilter = new RequestFilter(name, rqPipelineTemplate);
                FilterRegistration.Dynamic filter = ctx.addFilter(String.valueOf(name) + "-filter", (Filter)requestFilter);
                filter.addMappingForUrlPatterns(null, false, new String[]{mapping});
            }
        }
    }

    private void registerManagementServlet(ServletContext ctx) {
        ServletRegistration.Dynamic lifetime = ctx.addServlet(String.valueOf(ctx.getServletContextName()) + "-lifetime", ServiceLifetime.class);
        lifetime.addMapping(new String[]{String.valueOf(ctx.getContextPath()) + "/lifetime"});
    }

    private void startLifetimeHandlers(ServletContext ctx, LifecycleConfiguration configuration) {
        try {
            StartServiceEvent start = new StartServiceEvent(ctx);
            List<LifetimeHandler> ltHandlers = configuration.lifetimeHandlers();
            this.ltPipeline = new DefaultPipeline<LifetimeHandler>(ltHandlers, this.context);
            this.ltPipeline.forward(start);
        }
        catch (RuntimeException e) {
            this.context.lifecycle().tryMoveTo(State.failed);
            throw e;
        }
    }

    private void stopLifetimeHandlers(ServletContext ctx) {
        if (this.ltPipeline == null) {
            return;
        }
        StopServiceEvent stop = new StopServiceEvent(ctx);
        List<LifetimeHandler> reversedHandlers = this.ltPipeline.handlers();
        Collections.reverse(reversedHandlers);
        DefaultPipeline<LifetimeHandler> returnPipeline = new DefaultPipeline<LifetimeHandler>(reversedHandlers, this.context);
        returnPipeline.forward(stop);
    }
}

