/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.ghn.service.configuration;

import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import org.gcube.common.ghn.service.configuration.ServiceConfiguration;
import org.gcube.common.ghn.service.handlers.LifetimeHandler;
import org.gcube.common.ghn.service.handlers.RequestHandler;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.scannotation.ClasspathUrlFinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationBinder {
    private static final Logger log = LoggerFactory.getLogger(ConfigurationBinder.class);

    public ServiceConfiguration bind(InputStream stream) throws RuntimeException {
        Class[] classes = this.scanForHandlers();
        try {
            JAXBContext ctx = JAXBContext.newInstance((Class[])classes);
            return (ServiceConfiguration)ctx.createUnmarshaller().unmarshal(stream);
        }
        catch (JAXBException e) {
            throw new RuntimeException("invalid service configuration", e);
        }
    }

    Class<?>[] scanForHandlers() throws RuntimeException {
        HashSet bindings = new HashSet();
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        URL[] archives = ClasspathUrlFinder.findResourceBases((String)"WEB-INF/gcube-service.xml", (ClassLoader)loader);
        if (archives.length == 0) {
            throw new RuntimeException("no service handler found on classpath");
        }
        ConfigurationBuilder b = new ConfigurationBuilder().addUrls(archives).addUrls((Collection)ClasspathHelper.forPackage((String)"org.gcube.common.ghn.service", (ClassLoader[])new ClassLoader[]{loader}));
        Reflections r = new Reflections((Configuration)b);
        bindings.addAll(r.getSubTypesOf(RequestHandler.class));
        bindings.addAll(r.getSubTypesOf(LifetimeHandler.class));
        HashSet<Class<ServiceConfiguration>> purged = new HashSet<Class<ServiceConfiguration>>();
        for (Class binding : bindings) {
            if (binding.isInterface() || binding.getModifiers() == 1024) continue;
            purged.add(binding);
        }
        log.debug("found the following service handlers: {}", bindings);
        purged.add(ServiceConfiguration.class);
        return purged.toArray(new Class[0]);
    }
}

