/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.ghn.service;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterRegistration;
import javax.servlet.ServletContext;
import javax.servlet.ServletRegistration;
import org.gcube.common.ghn.service.RequestFilter;
import org.gcube.common.ghn.service.configuration.ConfigurationBinder;
import org.gcube.common.ghn.service.configuration.ServiceConfiguration;
import org.gcube.common.ghn.service.events.StartServiceEvent;
import org.gcube.common.ghn.service.events.StopServiceEvent;
import org.gcube.common.ghn.service.extensions.ServiceLifetime;
import org.gcube.common.ghn.service.handlers.DefaultPipeline;
import org.gcube.common.ghn.service.handlers.LifetimeHandler;
import org.gcube.common.ghn.service.handlers.Pipeline;
import org.gcube.common.ghn.service.handlers.RequestHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceManager {
    private static Logger log = LoggerFactory.getLogger(ServiceManager.class);
    private Pipeline<LifetimeHandler> ltPipeline;

    public void start(ServletContext ctx) throws RuntimeException {
        log.info("managing {}", (Object)ctx.getServletContextName());
        ServiceConfiguration configuration = null;
        try {
            ConfigurationBinder binder = new ConfigurationBinder();
            configuration = binder.bind(ctx.getResourceAsStream("/WEB-INF/gcube-service.xml"));
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
        List<LifetimeHandler> ltHandlers = configuration.lifetimeHandlers();
        this.ltPipeline = new DefaultPipeline<LifetimeHandler>(ltHandlers);
        this.ltPipeline.forward(new StartServiceEvent(ctx));
        List<RequestHandler> rqHandlers = configuration.requestHandlers();
        DefaultPipeline<RequestHandler> rqPipeline = new DefaultPipeline<RequestHandler>(rqHandlers);
        Collection servlets = ctx.getServletRegistrations().values();
        for (ServletRegistration servlet : servlets) {
            String name = servlet.getName();
            if (name.equals("default") || name.equals("jsp")) continue;
            for (String mapping : servlet.getMappings()) {
                FilterRegistration.Dynamic filter = ctx.addFilter(name + "-filter", (Filter)new RequestFilter(name, rqPipeline));
                filter.addMappingForUrlPatterns(null, false, new String[]{mapping});
            }
        }
        ServletRegistration.Dynamic lifetime = ctx.addServlet(ctx.getServletContextName() + "-lifetime", ServiceLifetime.class);
        lifetime.addMapping(new String[]{ctx.getContextPath() + "/lifetime"});
    }

    public void stop(ServletContext ctx) {
        List<LifetimeHandler> reversedHandlers = this.ltPipeline.handlers();
        Collections.reverse(reversedHandlers);
        DefaultPipeline<LifetimeHandler> returnPipeline = new DefaultPipeline<LifetimeHandler>(reversedHandlers);
        returnPipeline.forward(new StopServiceEvent(ctx));
    }
}

