/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.ghn.service;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.gcube.common.ghn.service.events.RequestEvent;
import org.gcube.common.ghn.service.events.ResponseEvent;
import org.gcube.common.ghn.service.handlers.DefaultPipeline;
import org.gcube.common.ghn.service.handlers.Pipeline;
import org.gcube.common.ghn.service.handlers.RequestHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestFilter
implements Filter {
    private static Logger log = LoggerFactory.getLogger(RequestFilter.class);
    private final String servletName;
    private final Pipeline<RequestHandler> pipeline;

    public RequestFilter(String servletName, Pipeline<RequestHandler> pipeline) {
        this.servletName = servletName;
        this.pipeline = pipeline;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        try {
            DefaultPipeline<RequestHandler> requestPipeline = new DefaultPipeline<RequestHandler>(this.pipeline.handlers());
            RequestEvent event = new RequestEvent(this.servletName, request);
            requestPipeline.forward(event);
            chain.doFilter(request, response);
            ResponseEvent responseEvent = new ResponseEvent(this.servletName, request, response);
            Pipeline<RequestHandler> returnPipeline = this.flip(requestPipeline);
            returnPipeline.forward(responseEvent);
        }
        catch (Throwable t) {
            throw new ServletException(t);
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        try {
            for (RequestHandler h : this.pipeline.handlers()) {
                h.start(filterConfig.getServletContext());
            }
        }
        catch (Throwable t) {
            throw new ServletException(t);
        }
    }

    public void destroy() {
        for (RequestHandler h : this.pipeline.handlers()) {
            try {
                h.stop();
            }
            catch (Throwable t) {
                log.error("cannot terminate handler {}", (Object)h.name());
            }
        }
    }

    Pipeline<RequestHandler> flip(Pipeline<RequestHandler> pipeline) {
        List<RequestHandler> reversedHandlers = pipeline.handlers();
        Collections.reverse(reversedHandlers);
        return new DefaultPipeline<RequestHandler>(reversedHandlers);
    }
}

