package org.gcube.common.ghn.service.handlers;

import org.gcube.common.ghn.service.events.ServiceEvent;

/**
 * Registers in {@link Pipeline}s to handle {@link ServiceEvent}s about a managed service.
 * <p>
 * Handlers may or may not propagate the events to the other handlers registered in the same pipeline
 * {@link Pipeline#forward(ServiceEvent)}.
 * 
 * @author Fabio Simeoni
 * 
 * @param <T> the (recursive) type of the handler.
 * 
 * @see ServiceEvent
 * @see Pipeline
 */
public interface ServiceHandler<T extends ServiceHandler<T>> {

	/**
	 * Returns the name of the handler.
	 * 
	 * @return the name
	 */
	String name();

	/**
	 * Processes a given event.
	 * 
	 * @param pipeline the pipeline in which the handler is registered.
	 * @param e the event
	 */
	void onEvent(Pipeline<T> pipeline, ServiceEvent<T> e);


}
