package org.gcube.common.ghn.service.handlers;

import java.util.List;

import org.gcube.common.ghn.service.events.ServiceEvent;

/**
 * An ordered list {@link ServiceHandler}s registered to handle {@link ServiceEvent}s of the same type.
 * <p>
 * Clients dispatch events to pipelines and handlers are responsible to forward them to subsequent handlers.
 * 
 * @author Fabio Simeoni
 * 
 * @param <T> the type of the registered handlers 
 * 
 * @see ServiceHandler
 * @see ServiceEvent
 *
 */
public interface Pipeline<T extends ServiceHandler<T>> {

	/**
	 * Returns the handlers currently in the pipeline.
	 * @return the handlers
	 */
	List<T> handlers();
	
	/**
	 * Forwards an event a step further through the pipeline.
	 * @param e the event
	 */
	void forward(ServiceEvent<T> e);
}
