package org.gcube.common.ghn.service.handlers;

import java.util.logging.Handler;

import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

import org.gcube.common.ghn.service.configuration.LifetimeHandlerAdapter;
import org.gcube.common.ghn.service.events.LifetimeEvent;
import org.gcube.common.ghn.service.events.ServiceEvent;
import org.gcube.common.ghn.service.events.StartServiceEvent;
import org.gcube.common.ghn.service.events.StopServiceEvent;

/**
 * A {@link Handler} of {@link LifetimeEvent}s.
 * <p>
 * The handler participates in a {@link Pipeline} of other handlers registered for notification of the same events.
 * After processing the event, it may or may not propagate the event to the handlers further down in the {@link Pipeline}
 * {@link Pipeline#forward(ServiceEvent)}.
 * @author Fabio Simeoni
 *
 * @see LifetimeEvent
 * @see Pipeline
 */
@XmlJavaTypeAdapter(LifetimeHandlerAdapter.class)
public abstract class LifetimeHandler extends AbstractHandler<LifetimeHandler> {

	/**
	 * Invoked when the container starts a managed service.
	 * @param pipeline the pipeline in which this handler is registered
	 * @param e the event
	 */
	public void onStart(Pipeline<LifetimeHandler> pipeline, StartServiceEvent e) {
		pipeline.forward(e);
	}

	/**
	 * Invoked when the container stops a managed service.
	 * @param pipeline the pipeline in which this handler is registered
	 * @param e the stop event
	 */
	public void onStop(Pipeline<LifetimeHandler> pipeline, StopServiceEvent e) {
		pipeline.forward(e);
	}
	
	@Override
	public void onEvent(Pipeline<LifetimeHandler> pipeline,ServiceEvent<LifetimeHandler> e) {
		
		if (e instanceof StartServiceEvent)
			onStart(pipeline,(StartServiceEvent) e);
		else
			if (e instanceof StopServiceEvent)
				onStop(pipeline,(StopServiceEvent) e);
	}
}
