package org.gcube.common.ghn.service.handlers;

import java.util.ArrayList;
import java.util.List;

import org.gcube.common.ghn.service.events.ServiceEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Default implementation of {@link Pipeline}.
 * 
 * @author Fabio Simeoni
 *
 * @param <T>
 */
public class DefaultPipeline<T extends ServiceHandler<T>> implements Pipeline<T> {

	private static Logger log = LoggerFactory.getLogger(DefaultPipeline.class);
	
	private final List<T> handlers;
	private int cursor=0;
	
	/**
	 * Creates an instance with a given set of handlers. 
	 * <p>
	 * Modification to the input {@link List} are not reflected in the {@link Pipeline}.
	 * 
	 * @param handlers the handlers
	 */
	public DefaultPipeline(List<T> handlers) {
		this.handlers=new ArrayList<T>(handlers); //we now own the ordering
	}
	
	@Override
	public List<T> handlers() {
		return new ArrayList<T>(handlers);
	}
	
	@Override
	public void forward(ServiceEvent<T> e) {
		
		if (cursor>=handlers.size())
			return;
		
		T handler = handlers.get(cursor);
		
		cursor++;
		
		log.debug("forwarding {} to {}",e,handler.name());
		
		handler.onEvent(this,e);

	}
	
}
