package org.gcube.common.ghn.service.events;

import javax.servlet.ServletContext;

import org.gcube.common.ghn.service.handlers.LifetimeHandler;
import org.gcube.common.ghn.service.handlers.Pipeline;

/**
 * A {@link ServiceEvent} that occurs when the service is started by the container.
 * <p>
 * The event is passed to {@link LifetimeHandler}s registered in {@link Pipeline}s.
 * 
 * @author Fabio Simeoni
 * 
 * @see LifetimeHandler
 * @see Pipeline
 */
public class StartServiceEvent extends LifetimeEvent {

	/**
	 * Creates an instance with the {@link ServletContext} of the managed service.
	 * 
	 * @param ctx the servlet context
	 */
	public StartServiceEvent(ServletContext ctx) {
		super(ctx);
	}

}
