package org.gcube.common.ghn.service.events;

import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

import org.gcube.common.ghn.service.RequestFilter;
import org.gcube.common.ghn.service.handlers.Pipeline;
import org.gcube.common.ghn.service.handlers.RequestHandler;

/**
 * A {@link ServiceEvent} that occurs when the a servlet returns a response to a given request.
 * <p>
 * The event is passed to {@link RequestHandler} registered in the {@link Pipeline}'s of {@link RequestFilter}.
 * 
 * @author Fabio Simeoni
 * 
 * @see RequestHandler
 * @see Pipeline
 * @see RequestFilter
 */
public class ResponseEvent extends RequestEvent {

	private final ServletResponse response;

	/**
	 * Creates an instance with the response, the corresponding request, and the name of the target servlet
	 * 
	 * @param servletName the name of the servlet
	 * @param request the request
	 * @param response the response
	 */
	public ResponseEvent(String servletName, ServletRequest request, ServletResponse response) {
		super(servletName, request);
		this.response = response;
	}

	/**
	 * Returns the response.
	 * 
	 * @return the response
	 */
	public ServletResponse response() {
		return response;
	}

	@Override
	public String toString() {
		return getClass().getSimpleName() + "[req=" + request().getRemoteHost() + ",resp="
				+ response.toString().substring(0, 12) + "]";
	}
}
