package org.gcube.common.ghn.service.events;

import javax.servlet.ServletRequest;

import org.gcube.common.ghn.service.RequestFilter;
import org.gcube.common.ghn.service.handlers.Pipeline;
import org.gcube.common.ghn.service.handlers.RequestHandler;

/**
 * A {@link ServiceEvent} that occurs when the a request reaches a servlet of the managed service.
 * <p>
 * The event is passed to {@link RequestHandler} registered in the {@link Pipeline}'s of {@link RequestFilter}.
 * 
 * @author Fabio Simeoni
 * 
 * @see RequestHandler
 * @see Pipeline
 * @see RequestFilter
 */
public class RequestEvent implements ServiceEvent<RequestHandler> {

	private final String servletName;
	private final ServletRequest request;

	/**
	 * Creates an instance with the request and the name of the target servlet.
	 * 
	 * @param servletName the name of the servlet
	 * @param request the request
	 */
	public RequestEvent(String servletName, ServletRequest request) {
		this.request = request;
		this.servletName = servletName;
	}

	/**
	 * Returns the name of the target servlet.
	 * 
	 * @return the name of the servlet.
	 */
	public String servletName() {
		return servletName;
	}

	/**
	 * Returns the request.
	 * 
	 * @return the request
	 */
	public ServletRequest request() {
		return request;
	}

	@Override
	public String toString() {
		return getClass().getSimpleName() + "[req=" + request.getRemoteHost() + "]";
	}
}
