package org.gcube.common.ghn.service.events;

import javax.servlet.ServletContext;

import org.gcube.common.ghn.service.handlers.LifetimeHandler;
import org.gcube.common.ghn.service.handlers.Pipeline;

/**
 * A {@link ServiceEvent} that relates to the lifetime of a managed service.
 * <p>
 * The event is passed to {@link LifetimeHandler}s registered in {@link Pipeline}s.
 * 
 * @author Fabio Simeoni
 * 
 * @see LifetimeHandler
 * @see Pipeline
 * 
 */
public abstract class LifetimeEvent implements ServiceEvent<LifetimeHandler> {

	private final ServletContext ctx;

	/**
	 * Creates an instance with the {@link ServletContext} of the managed service.
	 * 
	 * @param ctx the servlet context
	 */
	public LifetimeEvent(ServletContext ctx) {
		this.ctx = ctx;
	}

	/**
	 * Returns the {@link ServletContext} of the managed service.
	 * 
	 * @return the servlet context
	 */
	public ServletContext servletContext() {
		return ctx;
	}

	@Override
	public String toString() {
		return getClass().getSimpleName();
	}
}
