package org.gcube.common.ghn.service.configuration;

import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlAdapter;

import org.gcube.common.ghn.client.ClientService;
import org.gcube.common.ghn.client.ContainerConfiguration;
import org.gcube.common.ghn.service.handlers.LifetimeHandler;
import org.w3c.dom.Element;

/**
 * Adapts {@link ClientService} bindings found in a {@link ContainerConfiguration}.
 * 
 * @author Fabio Simeoni
 *
 */
public class LifetimeHandlerAdapter extends XmlAdapter<Object,LifetimeHandler> {

	/**
	 * A {@link LifetimeHandler} included in a {@link ServiceConfiguration} but not available at runtime.
	 * @author Fabio Simeoni
	 *
	 */
	@XmlType(name="lifetime-unavailable")
	public static class UnavailableHandler extends LifetimeHandler {

		private String name;
		
		public UnavailableHandler() {}
		/**
		 * Creates an instance with a given name
		 * @param name the name.
		 */
		public UnavailableHandler(String name) {
			this.name=name;
		}
		
		@Override
		public String name() {
			return name;
		}
		
		
	}
	
	@Override
	public Object marshal(LifetimeHandler handler) throws Exception {
		return handler;
	}

	@Override
	public LifetimeHandler unmarshal(Object handler) throws Exception {
		if (handler instanceof LifetimeHandler)
			return (LifetimeHandler) handler;
		else
			return new UnavailableHandler(((Element)handler).getLocalName());
	}

}
