package org.gcube.common.ghn.service;

import java.util.Set;

import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;

/**
 * Adds a {@link LifetimeListener} to managed services.
 * <p>
 * It is automatically discovered from a service library or a shared library in servlet containers that comply with
 * version 3.0 or later of the Servlet specifications.
 * 
 * @author Fabio Simeoni
 * 
 */
public class ServiceInitializer implements ServletContainerInitializer {

	@Override
	public void onStartup(Set<Class<?>> c, ServletContext ctx) throws ServletException {

		//pass through for non managed services
		if (isManagedService(ctx))
			// register service listener
			ctx.addListener(new LifetimeListener());
	}

	private boolean isManagedService(ServletContext ctx) {
		return ctx.getResourceAsStream("/" + Constants.configuration_file) != null;
	}

}
