/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.ghn.client;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.gcube.common.ghn.client.ConfigurationBinder;
import org.gcube.common.ghn.client.ContainerConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationProvider {
    private static Logger log = LoggerFactory.getLogger(ConfigurationProvider.class);
    private ConfigurationBinder binder = new ConfigurationBinder();

    ContainerConfiguration provide() throws RuntimeException {
        InputStream stream = this.provideFromProperty();
        if (stream == null) {
            stream = this.provideFromClasspath();
        }
        if (stream == null) {
            throw new RuntimeException("cannot find client container configuration");
        }
        return this.binder.bind(stream);
    }

    InputStream provideFromProperty() throws RuntimeException {
        String property = System.getProperty("client.configuration");
        if (property == null || property.isEmpty()) {
            log.info("property {} is not set", (Object)"client.configuration");
            return null;
        }
        try {
            return new FileInputStream(property);
        }
        catch (IOException e) {
            throw new RuntimeException("invalid configuration location ", e);
        }
    }

    InputStream provideFromClasspath() {
        log.info("looking for {} in classpath", (Object)"client-config.xml");
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        return loader.getResourceAsStream("client-config.xml");
    }
}

