/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.ghn.client;

import java.io.InputStream;
import java.net.URL;
import java.util.HashSet;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import org.gcube.common.ghn.client.ClientService;
import org.gcube.common.ghn.client.ContainerConfiguration;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.SubTypesScanner;
import org.reflections.util.ConfigurationBuilder;
import org.scannotation.ClasspathUrlFinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ConfigurationBinder {
    private static final Logger log = LoggerFactory.getLogger(ConfigurationBinder.class);

    ConfigurationBinder() {
    }

    ContainerConfiguration bind(InputStream stream) throws RuntimeException {
        Class[] classes = this.scanForServices();
        try {
            JAXBContext ctx = JAXBContext.newInstance((Class[])classes);
            return (ContainerConfiguration)ctx.createUnmarshaller().unmarshal(stream);
        }
        catch (JAXBException e) {
            throw new RuntimeException("invalid configuration", e);
        }
    }

    Class<?>[] scanForServices() throws RuntimeException {
        HashSet<Class<ContainerConfiguration>> bindings = new HashSet<Class<ContainerConfiguration>>();
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        URL[] archives = ClasspathUrlFinder.findResourceBases((String)"META-INF/clientservice", (ClassLoader)loader);
        if (archives.length == 0) {
            throw new RuntimeException("no client service is available on the classpath");
        }
        ConfigurationBuilder b = new ConfigurationBuilder().addUrls(archives).addScanners(new Scanner[]{new SubTypesScanner()});
        Reflections r = new Reflections((Configuration)b);
        bindings.addAll(r.getSubTypesOf(ClientService.class));
        if (bindings.size() > 0) {
            log.debug("found the following client services: {}", bindings);
        } else {
            log.debug("found no client service");
        }
        bindings.add(ContainerConfiguration.class);
        return bindings.toArray(new Class[0]);
    }
}

