/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.ghn.client;

import java.util.ArrayList;
import java.util.List;
import org.gcube.common.ghn.client.ClientService;
import org.gcube.common.ghn.client.ConfigurationProvider;
import org.gcube.common.ghn.client.ContainerConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ClientContainer {
    private static Logger log = LoggerFactory.getLogger(ClientContainer.class);
    private static ContainerConfiguration configuration;
    private static boolean isRunning;

    private ClientContainer() {
    }

    public static synchronized void start() throws RuntimeException {
        ConfigurationProvider provider = new ConfigurationProvider();
        ContainerConfiguration configuration = provider.provide();
        ClientContainer.start(configuration);
    }

    public static ContainerConfiguration configuration() {
        return configuration;
    }

    public static synchronized boolean isRunning() {
        return isRunning;
    }

    public static synchronized void start(ContainerConfiguration configuration) throws IllegalArgumentException, RuntimeException {
        if (configuration == null) {
            throw new IllegalArgumentException("configuration is null");
        }
        List<ClientService> services = configuration.services();
        if (services == null || services.isEmpty()) {
            throw new IllegalArgumentException("no client services configured");
        }
        if (isRunning) {
            return;
        }
        ClientContainer.configuration = configuration;
        log.info("starting client container");
        isRunning = true;
        ArrayList<ClientService> started = new ArrayList<ClientService>();
        for (ClientService service : configuration.services()) {
            try {
                service.start();
                started.add(service);
            }
            catch (Throwable t) {
                ClientContainer.stop(started);
                throw new RuntimeException(t);
            }
        }
    }

    public static synchronized void stop() {
        if (isRunning) {
            ClientContainer.stop(configuration.services());
        }
    }

    public static synchronized void stop(List<ClientService> services) {
        if (!isRunning) {
            return;
        }
        log.info("stopping client container");
        for (ClientService service : services) {
            service.stop();
        }
        isRunning = false;
        configuration = null;
    }
}

