/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.calls;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.gcube.common.calls.Call;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ServiceCache<T> {
    private static final Logger log = LoggerFactory.getLogger(ServiceCache.class);
    private volatile LRUCache cache = new LRUCache();
    private ConcurrentHashMap<Call, Lock> nameLocks = new ConcurrentHashMap();

    ServiceCache() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clear(Call name) {
        Lock nameLock = this.lockFor(name);
        nameLock.lock();
        try {
            this.cache.remove(name);
        }
        finally {
            nameLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    T get(Call name, Callable<T> task) {
        Lock nameLock = this.lockFor(name);
        nameLock.lock();
        try {
            Object service = this.cache.get(name);
            if (service == null) {
                try {
                    service = task.call();
                    log.trace("caching stub for " + name);
                    this.cache.put(name, service);
                }
                catch (Exception e) {
                    throw new RuntimeException("could not build service", e);
                }
            } else {
                log.trace("using cached stub for " + name);
            }
            Object object = service;
            return (T)object;
        }
        finally {
            nameLock.unlock();
        }
    }

    private Lock lockFor(Call name) {
        Lock nameLock = this.nameLocks.get(name);
        if (nameLock == null) {
            ReentrantLock newLock = new ReentrantLock();
            nameLock = this.nameLocks.putIfAbsent(name, newLock);
            nameLock = nameLock == null ? newLock : nameLock;
        }
        return nameLock;
    }

    private class LRUCache
    extends LinkedHashMap<Call, T> {
        private static final long serialVersionUID = 1L;
        public static final int max = 50;

        public LRUCache() {
            super(16, 0.75f, true);
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<Call, T> eldest) {
            if (this.size() >= 50) {
                ServiceCache.this.nameLocks.remove(eldest.getKey());
                return true;
            }
            return false;
        }
    }
}

