package org.gcube.common.encryption.encrypter;

import java.security.Key;

/**
 * @author Luca Frosini (ISTI - CNR)
 * 
 * @param <T> the type of the object to encrypt/decrypt
 */
public interface Encrypter<T> {
	
	/**
	 * Encrypts the object using the context key
	 * @param t the object to encrypt
	 * @return the encrypted object
	 * @throws Exception if encryption fails
	 */
	public T encrypt(T t) throws Exception;
	
	/**
	 * Encrypts the object using the provided key
	 * @param t the object to encrypt
	 * @param key the key to use for encryption
	 * @return the encrypted object
	 * @throws Exception if encryption fails
	 */
	public T encrypt(T t, Key key) throws Exception;
	
	/**
	 * Decrypts the object using the context key
	 * @param t the object to decrypt
	 * @return the decrypted object
	 * @throws Exception if decryption fails
	 */
	public T decrypt(T t) throws Exception;
	
	/**
	 * Decrypts the object using the provided key
	 * @param t the object to decrypt
	 * @param key the key to use for decryption
	 * @return the decrypted object
	 * @throws Exception if decryption fails
	 */
	public T decrypt(T t, Key key) throws Exception;
		
}
