package org.gcube.common.encryption;

import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;

/**
 * A simplified keys generator for the most common algorithms
 * @author Manuele Simi (CNR)
 * @author Roberto Cirillo (ISTI - CNR)
 * @author Luca Frosini (ISTI - CNR)
 */
public class KeyFactory {

	/**
     * Generates an AES key
     * @return the generated AES secret key
     * @throws Exception if key generation fails
     */
    public static SecretKey newAESKey() throws Exception {
       	KeyGenerator keyGenerator = KeyGenerator.getInstance("AES");
        keyGenerator.init(128);
        return keyGenerator.generateKey();
    }
    
    /**
     * Generates a TripleDES key
     * @return the generated TripleDES secret key
     * @throws Exception if key generation fails
     */
    public static SecretKey newTripleDESKey() throws Exception {
    	KeyGenerator keyGenerator = KeyGenerator.getInstance("TripleDES");
        //keyGenerator.init(168);
        return keyGenerator.generateKey();
    }
    
    /**
     * Generates a Rijndael key
     * @return the generated Rijndael secret key
     * @throws Exception if key generation fails
     */
    public static SecretKey newRijndaelKey() throws Exception {
    	KeyGenerator keyGenerator = KeyGenerator.getInstance("Rijndael");
        //keyGenerator.init(168);
        return keyGenerator.generateKey();
    }
    
    /**
     * Generates a DES key
     * @return the generated DES secret key
     * @throws Exception if key generation fails
     */
    public static SecretKey newDESKey() throws Exception {
    	KeyGenerator keyGenerator = KeyGenerator.getInstance("DES");
        //keyGenerator.init(168);
        return keyGenerator.generateKey();
    }
    
}
