/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.clients.queries;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gcube.common.clients.delegates.ProxyPlugin;
import org.gcube.common.clients.exceptions.DiscoveryException;
import org.gcube.common.clients.queries.Query;
import org.gcube.common.clients.queries.ResultMatcher;

public abstract class AbstractQuery<A, R>
implements Query<A> {
    private final ProxyPlugin<A, ?, ?> plugin;
    private final Map<String, String> conditions = new HashMap<String, String>();
    private ResultMatcher<R> matcher = new ResultMatcher<R>(){

        @Override
        public boolean match(R doc) {
            return true;
        }
    };

    protected AbstractQuery(ProxyPlugin<A, ?, ?> plugin) {
        this.plugin = plugin;
    }

    public void addCondition(String property, String value) {
        this.conditions.put(property, value);
    }

    public void setMatcher(ResultMatcher<R> matcher) {
        this.matcher = matcher;
    }

    @Override
    public final List<A> fire() throws DiscoveryException {
        List<R> results = this.fire(this.conditions);
        ArrayList<A> endpoints = new ArrayList<A>();
        for (R result : results) {
            try {
                if (!this.matcher.match(result)) continue;
                endpoints.add(this.address(result));
            }
            catch (IllegalArgumentException e) {}
        }
        return endpoints;
    }

    protected abstract List<R> fire(Map<String, String> var1) throws DiscoveryException;

    protected abstract A address(R var1) throws IllegalArgumentException;

    protected ProxyPlugin<A, ?, ?> plugin() {
        return this.plugin;
    }

    @Override
    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractQuery other = (AbstractQuery)obj;
        return !(this.conditions == null ? other.conditions != null : !((Object)this.conditions).equals(other.conditions));
    }

    @Override
    public final int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.conditions == null ? 0 : ((Object)this.conditions).hashCode());
        return result;
    }

    @Override
    public final String toString() {
        return this.conditions.toString();
    }
}

