/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.clients.delegates;

import java.util.ArrayList;
import java.util.List;
import org.gcube.common.clients.Call;
import org.gcube.common.clients.cache.EndpointCache;
import org.gcube.common.clients.cache.Key;
import org.gcube.common.clients.config.DiscoveryConfig;
import org.gcube.common.clients.config.ProxyConfig;
import org.gcube.common.clients.delegates.AbstractDelegate;
import org.gcube.common.clients.delegates.ProxyPlugin;
import org.gcube.common.clients.delegates.Unrecoverable;
import org.gcube.common.clients.exceptions.DiscoveryException;
import org.gcube.common.clients.queries.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiscoveryDelegate<A, S>
extends AbstractDelegate<A, S, DiscoveryConfig<A, S>> {
    private static Logger log = LoggerFactory.getLogger(DiscoveryDelegate.class);

    public DiscoveryDelegate(DiscoveryConfig<A, S> config) {
        super(config);
    }

    private boolean isAnchored() {
        return ((DiscoveryConfig)this.config()).hasProperty("sticky_session") ? ((DiscoveryConfig)this.config()).property("sticky_session", Boolean.class) : false;
    }

    @Override
    public <V> V make(Call<S, V> call) throws Exception {
        Object lgeAddress;
        Exception lastFault;
        Key key;
        EndpointCache cache;
        Query query;
        ProxyPlugin plugin;
        block15: {
            plugin = ((DiscoveryConfig)this.config()).plugin();
            query = ((DiscoveryConfig)this.config()).query();
            cache = ((DiscoveryConfig)this.config()).cache();
            key = Key.key(plugin.name(), query);
            lastFault = null;
            lgeAddress = cache.get(key);
            if (lgeAddress != null) {
                try {
                    log.info("calling {} @ {} (cached)", (Object)plugin.name(), lgeAddress);
                    Object lge = null;
                    try {
                        lge = plugin.resolve(lgeAddress, (ProxyConfig<?, ?>)this.config());
                    }
                    catch (Exception e) {
                        log.error("could not resolve " + lgeAddress, (Throwable)e);
                        lastFault = e;
                        break block15;
                    }
                    return call.call(lge);
                }
                catch (Exception fault) {
                    cache.clear(key);
                    fault = plugin.convert(fault, (ProxyConfig<?, ?>)this.config());
                    if (this.isUnrecoverable(fault) || this.isAnchored()) {
                        throw fault;
                    }
                    lastFault = fault;
                }
            }
        }
        List results = null;
        try {
            log.info("executing query for {} endpoints: {}", (Object)plugin.name(), query);
            results = query.fire();
            results = this.filterResults(lgeAddress, results);
            if (results.size() == 0) {
                throw new DiscoveryException("no endpoints found for " + query);
            }
        }
        catch (DiscoveryException fault) {
            if (lastFault == null) {
                throw fault;
            }
            throw lastFault;
        }
        for (Object address : results) {
            try {
                log.info("calling {} @ {}", (Object)plugin.name(), address);
                Object stub = null;
                try {
                    stub = plugin.resolve(address, (ProxyConfig<?, ?>)this.config());
                }
                catch (Exception e) {
                    log.error("could not resolve " + address, (Throwable)e);
                    lastFault = e;
                }
                V result = call.call(stub);
                cache.put(key, address);
                return result;
            }
            catch (Exception fault) {
                lastFault = plugin.convert(fault, (ProxyConfig<?, ?>)this.config());
                if (!this.isUnrecoverable(lastFault) && !this.isAnchored()) continue;
                break;
            }
        }
        throw lastFault;
    }

    private <CR> boolean isUnrecoverable(Exception e) {
        try {
            return e.getClass().isAnnotationPresent(Unrecoverable.class);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private List<A> filterResults(A cached, List<A> results) {
        ArrayList<A> endpoints = new ArrayList<A>();
        for (A result : results) {
            if (result.equals(cached)) continue;
            endpoints.add(result);
        }
        return endpoints;
    }
}

