/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.clients;

import org.gcube.common.clients.Call;
import org.gcube.common.clients.Client;
import org.gcube.common.clients.EndpointCache;
import org.gcube.common.clients.ServiceProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PassThroughClient<S, E>
implements Client<S> {
    private static Logger logger = LoggerFactory.getLogger(PassThroughClient.class);
    private ServiceProvider<S, E> provider;
    private E endpoint;
    private EndpointCache<E> cache;

    public PassThroughClient(ServiceProvider<S, E> provider, E endpoint, EndpointCache<E> cache) {
        this.provider = provider;
        this.endpoint = endpoint;
        this.cache = cache;
    }

    @Override
    public <R> R make(Call<S, R> call) throws Exception {
        logger.info("calling {} @ {}", (Object)this.provider.name(), this.endpoint);
        try {
            R result = call.call(this.provider.service(this.endpoint));
            this.cache.put(this.provider.name(), this.endpoint);
            return result;
        }
        catch (Exception e) {
            this.cache.clear(this.provider.name());
            throw e;
        }
    }
}

