/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.clients;

import java.util.ArrayList;
import java.util.List;
import org.gcube.common.clients.Call;
import org.gcube.common.clients.Client;
import org.gcube.common.clients.DiscoveryException;
import org.gcube.common.clients.EndpointCache;
import org.gcube.common.clients.Query;
import org.gcube.common.clients.ServiceProvider;
import org.gcube.common.clients.Unrecoverable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiscoveryClient<S, E>
implements Client<S> {
    private static Logger logger = LoggerFactory.getLogger(DiscoveryClient.class);
    private ServiceProvider<S, E> provider;
    private Query<E> query;
    private EndpointCache<E> cache;

    public DiscoveryClient(ServiceProvider<S, E> provider, Query<E> query, EndpointCache<E> cache) {
        this.provider = provider;
        this.query = query;
        this.cache = cache;
    }

    @Override
    public <CR> CR make(Call<S, CR> call) throws Exception {
        List<E> results;
        Exception lastFailure = null;
        E cached = this.cache.get(this.provider.name());
        if (cached != null) {
            try {
                logger.info("calling {} @ {} (cached)", (Object)this.provider.name(), cached);
                return call.call(this.provider.service(cached));
            }
            catch (Exception t) {
                this.cache.clear(this.provider.name());
                if (this.isUnrecoverable(call) || this.isUnrecoverable(t)) {
                    throw t;
                }
                lastFailure = t;
            }
        }
        if ((results = this.query.fire()).size() == 0) {
            throw new DiscoveryException("no service found");
        }
        List<E> endpoints = this.excludeFromQuery(cached, results);
        if (endpoints.size() == 0) {
            throw lastFailure;
        }
        for (E endpoint : endpoints) {
            try {
                logger.info("calling {} @ {}", (Object)this.provider.name(), endpoint);
                CR result = call.call(this.provider.service(endpoint));
                this.cache.put(this.provider.name(), endpoint);
                return result;
            }
            catch (Exception t) {
                lastFailure = t;
                if (!this.isUnrecoverable(call) && !this.isUnrecoverable(t)) continue;
                break;
            }
        }
        throw lastFailure;
    }

    private <CR> boolean isUnrecoverable(Exception e) {
        try {
            return e.getClass().isAnnotationPresent(Unrecoverable.class);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private <CR> boolean isUnrecoverable(Call<S, CR> call) {
        try {
            return call.getClass().getMethod("call", Object.class).isAnnotationPresent(Unrecoverable.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private List<E> excludeFromQuery(E cached, List<E> results) {
        ArrayList<E> endpoints = new ArrayList<E>();
        for (E result : results) {
            if (result.equals(cached)) continue;
            endpoints.add(result);
        }
        return endpoints;
    }
}

