/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.clients;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.gcube.common.clients.EndpointCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseEndpointCache<E>
implements EndpointCache<E> {
    private static Logger logger = LoggerFactory.getLogger(BaseEndpointCache.class);
    private Map<String, E> cache = Collections.synchronizedMap(new HashMap());

    @Override
    public void clear() {
        logger.debug("clearing cache {}", (Object)this);
        this.cache.clear();
    }

    @Override
    public void clear(String name) {
        this.check(name);
        logger.debug("clearing cache {} for {}", (Object)this, (Object)name);
        this.cache.put(name, null);
    }

    @Override
    public E get(String name) throws IllegalArgumentException {
        this.check(name);
        return this.cache.get(name);
    }

    @Override
    public void put(String name, E endpoint) throws IllegalArgumentException {
        this.check(name);
        if (endpoint == null) {
            throw new IllegalArgumentException("service endpoint is null");
        }
        logger.debug("caching {} for {}", endpoint, (Object)name);
        this.cache.put(name, endpoint);
    }

    private void check(String name) throws IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException("service name is null");
        }
    }
}

