package org.gcube.common.clients;

/**
 * Provides services at given endpoints.
 * 
 * @author Fabio Simeoni
 *
 * @param <S> the type of the service
 * @param <E> the type of the endpoints
 */
public interface ServiceProvider<S,E> {

	/**
	 * Returns the name of the service
	 * @return the name
	 */
	String name();
	
	/**
	 * Returns a service at an endpoint.
	 * @param endpoint the endpoint
	 * @return the service
	 */
	S service(E endpoint);
}
