package org.gcube.common.clients;

import java.util.List;


/**
 * A query for service endpoints.
 * 
 * @author Fabio Simeoni
 *
 * @param <E> the type of the service endpoints
 */
public interface Query<E> {

	/**
	 * Executes the query.
	 * 
	 * @return the discovered endpoints
	 * @throws DiscoveryException of the query fails
	 */
	List<E> fire() throws DiscoveryException;
}
