package org.gcube.common.clients;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;



/**
 * A {@link Client} that sends {@link Call}s to services at known endpoints, 
 * @author Fabio Simeoni
 *
 * @param <S> the type of the services
 */
public class PassThroughClient<S,E> implements Client<S> {

	private static Logger logger = LoggerFactory.getLogger(PassThroughClient.class);
	
	private ServiceProvider<S,E> provider;
	private E endpoint;
	private EndpointCache<E> cache;
	
	/**
	 * Creates an instance with a {@link ServiceProvider} and an endpoint.
	 * @param provider information about the service
	 * @param endpoint the endpoint
	 */
	public PassThroughClient(ServiceProvider<S,E> provider, E endpoint, EndpointCache<E> cache) {
		this.provider=provider;
		this.endpoint=endpoint;
		this.cache=cache;
	}
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	public <R> R make(Call<S, R> call) throws Exception {
		
		logger.info("calling {} @ {}",provider.name(),endpoint);
		
		try {
			R result = call.call(provider.service(endpoint));
			cache.put(provider.name(),endpoint);
			return result;
		}
		catch(Exception e) {
			cache.clear(provider.name());
			throw e;
		}
	}
}
