package org.gcube.common.clients;

/**
 * A cache of service endpoints.
 * <p>
 * Note that the cache is scope-unaware,i.e. it will maintain endpoints irrespective of the scope in which services <em>may</em> be.
 * Clients that target scoped services should use different caches for different scopes.
 * 
 * 
 * @author Fabio Simeoni
 *
 */
public interface EndpointCache<E> {

	/**
	 * Reset the cache.
	 */
	void clear();
	
	/**
	 * Reset the cache for a given service.
	 * @param name the service name
	 * @throws IllegalArgumentException if the name is <code>null</code>
	 */
	void clear(String name) throws IllegalArgumentException;
	
	/**
	 * Returns the endpoint cached for a given service
	 * @param name the name of the service
	 * @return the endpoint, or <code>null</code> if there is no endpoint cached for the service
	 * @throws IllegalArgumentException if the name is <code>null</code>
	 */
	E get(String name) throws IllegalArgumentException;
	
	/**
	 * Caches the endpoint of a given service
	 * @param name the service name
	 * @param endpoint the endpoint
	 * @throws IllegalArgumentException if the name or the endpoint are <code>null</code>
	 */
	void put(String name,E endpoint) throws IllegalArgumentException;
}
