package org.gcube.common.clients;


/**
 * A generic client that makes {@link Call}s to a service.
 * 
 * @author Fabio Simeoni
 *
 * @param <S> the type of the service
 * @see Call
 */
public interface Client<S> {

	/**
	 * Makes a {@link Call} to the service.
	 * @param call the call
	 * @param <R> the type of the value returned from the call
	 * @return the value returned from the call
	 * @throws Exception if the call fails
	 * 
	 */
	<R> R make(Call<S,R> call) throws Exception;
}
