package org.gcube.common.clients;

/**
 * A call to a service.
 * 
 * @author Fabio Simeoni
 *
 * @param <S> the service type
 * @param <R> the type of the value returned from the call
 */
public interface Call<S,R> {

	//!!!! do not change this signature without changing reflective check in DiscoveryClient 
	/**
	 * Calls the service
	 * @param service the service
	 * @return the value returned by the call
	 * @throws Exception if the call fails
	 */
	R call(S service) throws Exception;
}
