package org.gcube.common.clients;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Specified on {@link Call#call(Object)} to short-circuit endpoint iteration in the interaction strategy of {@link DiscoveryClient}s. 
 * 
 * @author Fabio Simeoni
 * @see Call
 * @see DiscoveryClient
 * 
 */
@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.TYPE,ElementType.METHOD})
@Inherited
@Documented
public @interface Unrecoverable {}
