/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.clients.delegates;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.gcube.common.clients.Call;
import org.gcube.common.clients.config.ProxyConfig;
import org.gcube.common.clients.delegates.Callback;
import org.gcube.common.clients.delegates.ProxyDelegate;
import org.gcube.common.security.providers.SecretManagerProvider;
import org.gcube.common.security.secrets.Secret;

public class AsyncProxyDelegate<S>
implements ProxyDelegate<S> {
    private static final ExecutorService service = Executors.newCachedThreadPool();
    private final ProxyDelegate<S> inner;

    public AsyncProxyDelegate(ProxyDelegate<S> delegate) {
        this.inner = delegate;
    }

    @Override
    public <V> V make(Call<S, V> call) throws Exception {
        return this.inner.make(call);
    }

    @Override
    public ProxyConfig<?, S> config() {
        return this.inner.config();
    }

    public <V> Future<V> makeAsync(Call<S, V> call) throws RejectedExecutionException {
        return this.makeAsync(call, service);
    }

    public <V> Future<V> makeAsync(final Call<S, V> call, ExecutorService service) throws RejectedExecutionException {
        final Secret secret = SecretManagerProvider.get();
        Callable callTask = new Callable<V>(){

            @Override
            public V call() throws Exception {
                SecretManagerProvider.set((Secret)secret);
                return AsyncProxyDelegate.this.inner.make(call);
            }
        };
        return service.submit(callTask);
    }

    public <V> Future<?> makeAsync(Call<S, V> call, Callback<V> callback) throws RejectedExecutionException {
        return this.makeAsync(call, callback, service);
    }

    public <V> Future<?> makeAsync(Call<S, V> call, final Callback<V> callback, ExecutorService service) throws RejectedExecutionException {
        final Future<V> callFuture = this.makeAsync(call, service);
        Runnable waitingTask = new Runnable(){

            @Override
            public void run() {
                try {
                    long timeout = callback.timeout();
                    Object outcome = null;
                    outcome = timeout == 0L ? (Object)callFuture.get() : (Object)callFuture.get(timeout, TimeUnit.MILLISECONDS);
                    callback.done(outcome);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                catch (ExecutionException e) {
                    callback.onFailure(e.getCause());
                }
                catch (TimeoutException e) {
                    callFuture.cancel(true);
                    callback.onFailure(e);
                }
            }
        };
        service.submit(waitingTask);
        return callFuture;
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                service.shutdown();
            }
        });
    }
}

