package org.gcube.common.clients.delegates;

import java.util.concurrent.TimeoutException;

import org.gcube.common.clients.Call;

/**
 * Asynchronous {@link Call} listeners.
 * 
 * @author Fabio Simeoni
 *
 * @param <V> the type of value returned by the call
 * 
 * @see Call
 */
public interface Callback<V> {

	/**
	 * Invoked when the value returned by the call is available.
	 * @param value the value
	 */
	void done(V value);
	
	/**
	 * Invoked when the call does not complete successfully.
	 * <p>
	 * Failures may be generated by a {@link Call}s, or by the expiration of timeouts set on their 
	 * asynchronous execution. In the latter case, the failures are {@link TimeoutException}s.
	 * 
	 * @param failure the failure
	 */
	void onFailure(Throwable failure); 
	
	
	/**
	 * The time to wait on the value returned by the call.
	 * @return the timeout
	 */
	long timeout();
	
	
	
}
