/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.viewmanager.stubs.calls;

import java.util.UUID;
import javax.xml.namespace.QName;
import org.apache.axis.message.addressing.AttributedURI;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.apache.axis.types.URI;
import org.gcube.common.core.faults.GCUBEException;
import org.gcube.common.core.faults.GCUBEUnrecoverableException;
import org.gcube.common.core.informationsystem.client.ISQuery;
import org.gcube.common.core.informationsystem.client.queries.WSResourceQuery;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.security.GCUBESecurityManager;
import org.gcube.common.core.utils.calls.GCUBECall;
import org.gcube.common.core.utils.calls.WSCall;
import org.gcube.common.core.utils.handlers.GCUBEServiceClientImpl;
import org.gcube.contentmanagement.viewmanager.stubs.FactoryPortType;
import org.gcube.contentmanagement.viewmanager.stubs.VMSCreateParams;
import org.gcube.contentmanagement.viewmanager.stubs.View;
import org.gcube.contentmanagement.viewmanager.stubs.ViewPortType;
import org.gcube.contentmanagement.viewmanager.stubs.ViewReference;
import org.gcube.contentmanagement.viewmanager.stubs.calls.FactoryParameters;
import org.gcube.contentmanagement.viewmanager.stubs.calls.StubFactory;
import org.gcube.contentmanagement.viewmanager.stubs.calls.Utils;
import org.oasis.wsrf.lifetime.Destroy;

public class ViewCall
extends WSCall {
    private static final QName VIEW_NAME = View.getTypeDesc().getXmlType();
    private final String pluginConditionFormat = "some $plugin in $result/child::*[local-name()='Plugin'] satisfies $plugin/child::*[local-name()='%1$s'] eq '%2$s'";
    private String plugin;
    private StubFactory stubFactory;

    public ViewCall(GCUBEScope scope, GCUBESecurityManager ... securityManager) throws Exception {
        this("DefaultVMPlugin", scope, securityManager);
    }

    public ViewCall(String name, GCUBEScope scope, GCUBESecurityManager ... securityManager) throws Exception {
        this(new StubFactory(), name, scope, securityManager);
    }

    protected ViewCall(StubFactory factory, String name, GCUBEScope scope, GCUBESecurityManager ... securityManager) throws Exception {
        super(scope, securityManager);
        this.stubFactory = factory;
        this.setPlugin(name);
        clients.put(((Object)((Object)this)).getClass(), new GCUBEServiceClientImpl(){

            public GCUBEScope getScope() {
                return ViewCall.this.getScopeManager().getScope();
            }
        });
    }

    protected String getServiceClass() {
        return "ContentManagement";
    }

    protected String getServiceName() {
        return "ViewManager";
    }

    protected String getPortTypeName() {
        return "gcube/contentmanagement/viewmanager/factory";
    }

    public void setEndpoint(String hostname, String port) throws Exception {
        this.setEndpointReference(new EndpointReferenceType((URI)new AttributedURI("http://" + hostname + ":" + port + "/wsrf/services/" + this.getPortTypeName())));
    }

    protected synchronized void setPlugin(String name) {
        if (this.plugin == null) {
            ((WSResourceQuery)this.getQuery()).addGenericCondition(String.format("some $plugin in $result/child::*[local-name()='Plugin'] satisfies $plugin/child::*[local-name()='%1$s'] eq '%2$s'", "name", name));
            this.plugin = name;
        } else if (!this.plugin.equals(name)) {
            throw new IllegalStateException("call previously used with a different plugin and not yet reset");
        }
    }

    public synchronized void resetQuery() throws Exception {
        this.setQuery((ISQuery)this.getInitQuery());
    }

    public org.gcube.contentmanagement.viewmanager.stubs.model.View create(org.gcube.contentmanagement.viewmanager.stubs.model.View view, boolean ... broadcast) throws Exception, GCUBEException {
        if (view.getId() == null) {
            view.setId(UUID.randomUUID().toString());
        }
        final FactoryParameters parameters = new FactoryParameters();
        parameters.setPlugin(this.plugin);
        if (broadcast == null || broadcast.length == 0 || !broadcast[0]) {
            parameters.setBroadcast(false);
        } else {
            parameters.setBroadcast(true);
        }
        parameters.setView(view);
        ReturnCallHandler<ViewReference> handler = new ReturnCallHandler<ViewReference>(){

            @Override
            public void call(EndpointReferenceType epr) throws Exception {
                FactoryPortType factory = ViewCall.this.stubFactory.getViewFactoryStub(epr, this.getScopeManager(), this.getSecurityManager());
                this.setResult(factory.create(Utils.toStub(parameters, VMSCreateParams.class, new boolean[0])));
            }
        };
        handler.run();
        org.gcube.contentmanagement.viewmanager.stubs.model.View v = Utils.toObject(((ViewReference)handler.getResult()).getView(), VIEW_NAME, org.gcube.contentmanagement.viewmanager.stubs.model.View.class, new boolean[0]);
        v.setEndpointReference(((ViewReference)handler.getResult()).getEndpointReference());
        return v;
    }

    public void destroy(EndpointReferenceType epr) throws GCUBEUnrecoverableException {
        try {
            ViewPortType view = this.stubFactory.getViewStub(epr, this.getScopeManager(), this.getSecurityManager());
            view.destroy(new Destroy());
        }
        catch (Exception e) {
            throw new GCUBEUnrecoverableException((Throwable)e);
        }
    }

    protected abstract class ReturnCallHandler<T>
    extends CallHandler {
        GCUBECall.ResultHolder<T> holder;

        public ReturnCallHandler() {
            this.setResult(null);
        }

        protected T getResult() {
            return (T)this.holder.value;
        }

        protected void setResult(T r) {
            this.holder = new GCUBECall.ResultHolder();
            this.holder.value = r;
        }
    }

    protected abstract class CallHandler
    extends WSCall.WSCallHandler {
        protected CallHandler() {
            super((WSCall)ViewCall.this);
        }

        public void interact(EndpointReferenceType epr) throws Exception {
            try {
                this.call(epr);
            }
            catch (Exception e) {
                if (ViewCall.this.getEndpointReference() == null) {
                    throw e;
                }
                throw new GCUBEUnrecoverableException((Throwable)e);
            }
        }

        public abstract void call(EndpointReferenceType var1) throws Exception;
    }
}

