/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.timeseriesservice.calls.timeseries;

import java.rmi.Remote;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.gcube.common.core.contexts.GCUBERemotePortTypeContext;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.security.GCUBESecurityManager;
import org.gcube.common.core.types.StringArray;
import org.gcube.common.core.types.VOID;
import org.gcube.contentmanagement.timeseriesservice.stubs.AddFAOAreasRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.AggregateRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.AggregationFunction;
import org.gcube.contentmanagement.timeseriesservice.stubs.ChangeColumnRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.ChartDataRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.CompatibleColumnsRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.CurrentState;
import org.gcube.contentmanagement.timeseriesservice.stubs.DenormalizeRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.DistinctValuesRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.EnrichRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.GetAllDataAsJsonRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.GetAreaTransformationResultRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.GetFishingMontlyEffortRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.GetSpaceSpeciesTransformationResultRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.GetSpaceTransformationResultRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.GetTimeCountriesTransformationResultRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.GetTransformationStatusResponse;
import org.gcube.contentmanagement.timeseriesservice.stubs.GroupElement;
import org.gcube.contentmanagement.timeseriesservice.stubs.GroupRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.IsUnionAllowedRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.OperationsListArray;
import org.gcube.contentmanagement.timeseriesservice.stubs.TimeSeriesManagerPortType;
import org.gcube.contentmanagement.timeseriesservice.stubs.TsFilterRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.UnionRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.service.TimeSeriesManagerServiceAddressingLocator;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.ColumnDefinition;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.CompatibleColumnsMapping;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.ExportRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.FieldMapping;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.FilterCondition;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.Limit;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.OperationType;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.Order;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.PublishingLevel;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.Status;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.TimeseriesHistory;

public class TimeSeriesServiceCall {
    private TimeSeriesManagerPortType tsManagerPT;
    private String user;

    public TimeSeriesServiceCall(String user, EndpointReferenceType epr, GCUBEScope scope, GCUBESecurityManager securityManager) throws Exception {
        this.user = user;
        this.tsManagerPT = new TimeSeriesManagerServiceAddressingLocator().getTimeSeriesManagerPortTypePort(epr);
        this.tsManagerPT = (TimeSeriesManagerPortType)GCUBERemotePortTypeContext.getProxy((Remote)this.tsManagerPT, (GCUBEScope)scope, (GCUBESecurityManager[])new GCUBESecurityManager[]{securityManager});
    }

    public ColumnDefinition[] getDimensions() throws Exception {
        return this.tsManagerPT.getColumnsDefinition(this.user).getColumnDefinition();
    }

    public Status getInitializingState() throws Exception {
        return this.tsManagerPT.getInitializationState(new VOID());
    }

    public String getAllDataAsJSon(Limit limit, Order order) throws Exception {
        return this.tsManagerPT.getAllDataAsJson(new GetAllDataAsJsonRequest(limit, order, this.user));
    }

    public String exportAsCsv(boolean hasHeader, String delimiter, String encoding, boolean[] fieldsMask) throws Exception {
        return this.tsManagerPT.exportAsCsv(new ExportRequest(delimiter, encoding, fieldsMask, hasHeader));
    }

    public void filter(FilterCondition filter) throws Exception {
        this.tsManagerPT.tsFilter(new TsFilterRequest(filter, this.user));
    }

    public void union(String timeSeriesId, FieldMapping ... fieldsMappings) throws Exception {
        this.tsManagerPT.union(new UnionRequest(fieldsMappings, timeSeriesId, this.user));
    }

    public void changeColumn(String fieldId, String keyId) throws Exception {
        this.tsManagerPT.changeColumn(new ChangeColumnRequest(fieldId, keyId, this.user));
    }

    public long getElementCount() throws Exception {
        return this.tsManagerPT.getElementsCount(this.user);
    }

    public void discardCurrentOperation() throws Exception {
        this.tsManagerPT.discardCurrentOperation(this.user);
    }

    public OperationType getCurrentOperation() throws Exception {
        return this.tsManagerPT.getCurrentOperation(this.user);
    }

    public CurrentState getCurrentState() throws Exception {
        return this.tsManagerPT.getCurrentState(this.user);
    }

    public FilterCondition getFilter() throws Exception {
        return this.tsManagerPT.getFilter(this.user);
    }

    public boolean isUnionAllowed(String otherResource) throws Exception {
        return this.tsManagerPT.isUnionAllowed(new IsUnionAllowedRequest(otherResource, this.user));
    }

    public void publish(PublishingLevel ... level) throws Exception {
        if (level == null || level.length == 0 || level[0] == PublishingLevel.VRE) {
            this.tsManagerPT.publish(PublishingLevel.VRE);
        } else {
            this.tsManagerPT.publish(PublishingLevel.VO);
        }
    }

    public void denormalization(String attributeFieldId, String valueFieldId) throws Exception {
        this.tsManagerPT.denormalize(new DenormalizeRequest(attributeFieldId, this.user, valueFieldId));
    }

    public void aggregate(AggregationFunction aggregationFuction, String ... fieldsId) throws Exception {
        this.tsManagerPT.aggregate(new AggregateRequest(aggregationFuction, fieldsId, this.user));
    }

    public void group(AggregationFunction aggregationFuction, GroupElement ... groupList) throws Exception {
        this.tsManagerPT.group(new GroupRequest(aggregationFuction, groupList, this.user));
    }

    public void enrich(String messageIdColumn, String rawDatesColumn, String speedColumn, String vesselIDColumn, String xDimensionColumn, String yDimensionColumn) throws Exception {
        this.tsManagerPT.enrich(new EnrichRequest(messageIdColumn, rawDatesColumn, speedColumn, this.user, vesselIDColumn, xDimensionColumn, yDimensionColumn));
    }

    public void addFAOAreas(String messageIdColumn, String xDimensionColumn, String yDimensionColumn) throws Exception {
        this.tsManagerPT.addFAOAreas(new AddFAOAreasRequest(messageIdColumn, this.user, xDimensionColumn, yDimensionColumn));
    }

    public void discardAllOperations() throws Exception {
        this.tsManagerPT.discardAllOperations(this.user);
    }

    public OperationType[] getOperationsList() throws Exception {
        OperationsListArray ola = this.tsManagerPT.getOperationsList(this.user);
        if (ola.getOperationsList() == null) {
            return new OperationType[0];
        }
        return ola.getOperationsList();
    }

    public TimeseriesHistory getHistory() throws Exception {
        return this.tsManagerPT.getHistory(new VOID());
    }

    public CompatibleColumnsMapping[] getCompatibleColumns(String timeSeriesId) throws Exception {
        return this.tsManagerPT.getCompatibleColumns(new CompatibleColumnsRequest(timeSeriesId, this.user)).getCompatibleColumnsMappingList();
    }

    public String getChartData(int maxDimension, String xDimension, String yDimension, String groupDimension, String attributeColumn, String[] filters, String[] areas) throws Exception {
        ChartDataRequest request = new ChartDataRequest();
        if (areas != null) {
            request.setAreas(new StringArray(areas));
        }
        if (filters != null) {
            request.setFilters(new StringArray(filters));
        }
        request.setAttributeColumn(attributeColumn);
        request.setGroupDimension(groupDimension);
        request.setXDimension(xDimension);
        request.setYDimension(yDimension);
        request.setMaxDimension(maxDimension);
        return this.tsManagerPT.getChartData(request);
    }

    public String[] getDistinctValues(String fieldId, Limit ... limit) throws Exception {
        DistinctValuesRequest distinctvaluesRequest = limit != null && limit.length > 0 ? new DistinctValuesRequest(fieldId, limit[0]) : new DistinctValuesRequest(fieldId, null);
        String[] items = this.tsManagerPT.getDistinctValues(distinctvaluesRequest).getItems();
        if (items != null) {
            return items;
        }
        return new String[0];
    }

    public String getAreaTransformationResult(String aggregationColumn, String quantitiesColumn) throws Exception {
        return this.tsManagerPT.getAreaTransformationResult(new GetAreaTransformationResultRequest(aggregationColumn, quantitiesColumn, this.user));
    }

    public String getSpaceTransformationResult(String aggregationColumn, String quantitiesColumn) throws Exception {
        return this.tsManagerPT.getSpaceTransformationResult(new GetSpaceTransformationResultRequest(aggregationColumn, quantitiesColumn, this.user));
    }

    public String getTimeCountriesTransformationResult(String aggregationColumn, String informationColumn, String quantitiesColumn) throws Exception {
        return this.tsManagerPT.getTimeCountriesTransformationResult(new GetTimeCountriesTransformationResultRequest(aggregationColumn, informationColumn, quantitiesColumn, this.user));
    }

    public String getSpaceSpeciesTransformationResult(String aggregationColumn, String informationColumn, String quantitiesColumn) throws Exception {
        return this.tsManagerPT.getSpaceSpeciesTransformationResult(new GetSpaceSpeciesTransformationResultRequest(aggregationColumn, informationColumn, quantitiesColumn, this.user));
    }

    public String getFishingMontlyEffort(String messageIdColumn, String datesColumn, String speedColumn, String fishingHoursDimension, String xDimensionColumn, String yDimensionColumn, boolean appendMode, boolean produceVTI) throws Exception {
        return this.tsManagerPT.getFishingMontlyEffort(new GetFishingMontlyEffortRequest(appendMode, datesColumn, fishingHoursDimension, messageIdColumn, produceVTI, speedColumn, this.user, xDimensionColumn, yDimensionColumn));
    }

    public GetTransformationStatusResponse getTransformationStatus(String groupName) throws Exception {
        return this.tsManagerPT.getTransformationStatus(groupName);
    }
}

