package org.gcube.contentmanagement.timeseriesservice.calls.importer;

import org.apache.axis.message.addressing.EndpointReferenceType;
import org.gcube.common.core.contexts.GCUBERemotePortTypeContext;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.security.GCUBESecurityManager;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.contentmanagement.timeseriesservice.calls.Constant;
import org.gcube.contentmanagement.timeseriesservice.calls.TSCall;
import org.gcube.contentmanagement.timeseriesservice.stubs.CreateImportRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.CreateImportResponse;
import org.gcube.contentmanagement.timeseriesservice.stubs.ImportFactoryPortType;
import org.gcube.contentmanagement.timeseriesservice.stubs.ImportedItem;
import org.gcube.contentmanagement.timeseriesservice.stubs.ImportedItemsArray;
import org.gcube.contentmanagement.timeseriesservice.stubs.service.ImportFactoryServiceAddressingLocator;



/**
 * 
 * @author Lucio Lelii
 *
 */
public class ImporterFactoryCall extends TSCall {

	GCUBELog logger= new GCUBELog(ImporterFactoryCall.class);
	
	public ImporterFactoryCall(GCUBEScope scope,
			GCUBESecurityManager[] securityManager) throws Exception {
		super(scope, securityManager);
	}

	
	@Override
	public String getPortTypeName() {
		return Constant.IMPORTER_FACTORY_PT_NAME;
	}
	
	
	/* (non-Javadoc)
	 * @see org.gcube.contentmanagement.timeseriesservice.stubs.calls.ImporterFactoryCallInterface#create(java.lang.String, java.lang.String, java.lang.String, java.lang.String, java.lang.String, java.lang.String, java.lang.String)
	 */
	public CreateImportResponse create(String title, String description, String creator, String publisher, String rights, String source, String type) throws Exception{
		final ResultHolder<CreateImportResponse> result = new ResultHolder<CreateImportResponse>();
		final CreateImportRequest createRequest= new CreateImportRequest(creator, description, publisher, rights, source,title, type);

		new RICallHandler() {
			
			public void interact(EndpointReferenceType epr) throws Exception {
				ImportFactoryPortType factoryPT= 
					new ImportFactoryServiceAddressingLocator().getImportFactoryPortTypePort(epr);
				factoryPT=GCUBERemotePortTypeContext.getProxy(factoryPT, getScopeManager(), getSecurityManager());
				result.value=factoryPT.createImportManager(createRequest);
			}
		}.run();
		return result.value;		
	}
	
	 
	/* (non-Javadoc)
	 * @see org.gcube.contentmanagement.timeseriesservice.stubs.calls.ImporterFactoryCallInterface#remove(java.lang.String)
	 */
	public void remove(final String id) throws Exception{
		new RICallHandler() {
			
			public void interact(EndpointReferenceType epr) throws Exception {
				ImportFactoryPortType factoryPT= new ImportFactoryServiceAddressingLocator().getImportFactoryPortTypePort(epr);
				factoryPT=GCUBERemotePortTypeContext.getProxy(factoryPT, getScopeManager(), getSecurityManager());
				factoryPT.removeImportManager(id);
			}
		}.run();
	}
	
	
	/* (non-Javadoc)
	 * @see org.gcube.contentmanagement.timeseriesservice.stubs.calls.ImporterFactoryCallInterface#getImportedItemsInfo()
	 */
	public ImportedItem[] getImportedItemsInfo(final String user) throws Exception{
		final ResultHolder<ImportedItem[]> result = new ResultHolder<ImportedItem[]>();
		new RICallHandler() {
			
			
			public void interact(EndpointReferenceType epr) throws Exception {
				ImportFactoryPortType factoryPT= new ImportFactoryServiceAddressingLocator().getImportFactoryPortTypePort(epr);
				factoryPT=GCUBERemotePortTypeContext.getProxy(factoryPT, getScopeManager(), getSecurityManager());
				ImportedItemsArray iaa=factoryPT.getImportedItems(user);
				ImportedItem[] toReturn;
				if (iaa==null || iaa.getItems()==null)
					toReturn= new ImportedItem[0];
				else
					toReturn= iaa.getItems();
				result.value=toReturn;
			}

		}.run();
        return result.value;
	}
	
	
	/* (non-Javadoc)
	 * @see org.gcube.contentmanagement.timeseriesservice.stubs.calls.ImporterFactoryCallInterface#getItemInfo(java.lang.String)
	 */
	public ImportedItem getItemInfo(final String importId) throws Exception{
		final ResultHolder<ImportedItem> result = new ResultHolder<ImportedItem>();
		
		new RICallHandler() {
			
			public void interact(EndpointReferenceType epr) throws Exception {
				ImportFactoryPortType factoryPT= new ImportFactoryServiceAddressingLocator().getImportFactoryPortTypePort(epr);
				factoryPT=GCUBERemotePortTypeContext.getProxy(factoryPT, getScopeManager(), getSecurityManager());
				result.value=factoryPT.getItem(importId);
			}

		}.run();
		return result.value;
	}


	public EndpointReferenceType open(final String importId) throws Exception {
		final ResultHolder<EndpointReferenceType> result = new ResultHolder<EndpointReferenceType>();
		
		new RICallHandler() {
			
			public void interact(EndpointReferenceType epr) throws Exception {
				ImportFactoryPortType factoryPT= new ImportFactoryServiceAddressingLocator().getImportFactoryPortTypePort(epr);
				factoryPT=GCUBERemotePortTypeContext.getProxy(factoryPT, getScopeManager(), getSecurityManager());
				result.value=factoryPT.openImport(importId);
			}

		}.run();
		return result.value;
	}
	
	
}
