/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.timeseriesservice.calls.codelist;

import java.rmi.Remote;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.gcube.common.core.contexts.GCUBERemotePortTypeContext;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.security.GCUBESecurityManager;
import org.gcube.contentmanagement.timeseriesservice.calls.NoServiceFoundException;
import org.gcube.contentmanagement.timeseriesservice.calls.codelist.CodeListCall;
import org.gcube.contentmanagement.timeseriesservice.stubs.CLImportedItem;
import org.gcube.contentmanagement.timeseriesservice.stubs.CLImportedItemsArray;
import org.gcube.contentmanagement.timeseriesservice.stubs.CodelistImportManagerPortType;
import org.gcube.contentmanagement.timeseriesservice.stubs.ImportFromCsvRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.ImportFromSdmxRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.ImportStatusResponse;
import org.gcube.contentmanagement.timeseriesservice.stubs.codelist.types.CodelistColumnDefinition;
import org.gcube.contentmanagement.timeseriesservice.stubs.codelist.types.CodelistIdentifier;
import org.gcube.contentmanagement.timeseriesservice.stubs.codelist.types.DataAsJsonRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.service.CodelistImportManagerServiceAddressingLocator;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.Limit;

public class CodelistImportCall
extends CodeListCall {
    private static HashMap<String, CodelistImportManagerPortType> clImportManagerPTMapping = new HashMap();
    private String user;
    private String id;
    private CodelistImportManagerPortType cachedPT;

    private static String getEndpoint() {
        return "gcube/contentmanagement/timeseriesservice/codelist/CodelistImport";
    }

    public static void setPT(GCUBEScope scope, EndpointReferenceType epr) throws NoServiceFoundException, Exception {
        CodelistImportManagerPortType pt = new CodelistImportManagerServiceAddressingLocator().getCodelistImportManagerPortTypePort(epr);
        pt = (CodelistImportManagerPortType)GCUBERemotePortTypeContext.getProxy((Remote)pt, (GCUBEScope)scope, (GCUBESecurityManager[])new GCUBESecurityManager[0]);
        clImportManagerPTMapping.put(scope.toString(), pt);
    }

    private static CodelistImportManagerPortType getCodelistImportManagerPortType(GCUBEScope scope, GCUBESecurityManager ... securityManager) throws NoServiceFoundException, Exception {
        if (clImportManagerPTMapping.get(scope.toString()) == null) {
            CodelistImportManagerPortType pt = new CodelistImportManagerServiceAddressingLocator().getCodelistImportManagerPortTypePort(CodelistImportCall.getEpr(scope, CodelistImportCall.getEndpoint()));
            pt = (CodelistImportManagerPortType)GCUBERemotePortTypeContext.getProxy((Remote)pt, (GCUBEScope)scope, (GCUBESecurityManager[])securityManager);
            clImportManagerPTMapping.put(scope.toString(), pt);
        }
        return clImportManagerPTMapping.get(scope.toString());
    }

    public static String importFromCsv(String user, String name, String description, String delimiter, String encoding, boolean hasHeader, String rsLocator, GCUBEScope scope, GCUBESecurityManager ... securityManager) throws NoServiceFoundException, Exception {
        ImportFromCsvRequest csvRequest = new ImportFromCsvRequest();
        csvRequest.setDelimiter(delimiter);
        csvRequest.setEncoding(encoding);
        csvRequest.setHasHeader(hasHeader);
        csvRequest.setOwner(user);
        csvRequest.setRsLocator(rsLocator);
        csvRequest.setName(name);
        csvRequest.setDescription(description);
        return CodelistImportCall.getCodelistImportManagerPortType(scope, securityManager).importFromCsv(csvRequest);
    }

    public static String importFromSdmxUri(String user, String sdmxURI, GCUBEScope scope, GCUBESecurityManager ... securityManager) throws NoServiceFoundException, Exception {
        ImportFromSdmxRequest sdmxRequest = new ImportFromSdmxRequest();
        sdmxRequest.setOwner(user);
        sdmxRequest.setSdmxUri(sdmxURI);
        sdmxRequest.setRsLocator(null);
        return CodelistImportCall.getCodelistImportManagerPortType(scope, securityManager).importFromSdmx(sdmxRequest);
    }

    public static String importFromSdmxFile(String user, String rsLocatorURI, GCUBEScope scope, GCUBESecurityManager ... securityManager) throws NoServiceFoundException, Exception {
        ImportFromSdmxRequest sdmxRequest = new ImportFromSdmxRequest();
        sdmxRequest.setOwner(user);
        sdmxRequest.setRsLocator(rsLocatorURI);
        sdmxRequest.setSdmxUri(null);
        return CodelistImportCall.getCodelistImportManagerPortType(scope, securityManager).importFromSdmx(sdmxRequest);
    }

    public static List<CLImportedItem> getItems(String user, GCUBEScope scope, GCUBESecurityManager ... securityManager) throws NoServiceFoundException, Exception {
        CLImportedItemsArray clArray = CodelistImportCall.getCodelistImportManagerPortType(scope, securityManager).getImportedCodelists(user);
        if (clArray.getItems() == null) {
            return new ArrayList<CLImportedItem>();
        }
        return Arrays.asList(clArray.getItems());
    }

    public static CLImportedItem getItem(String id, String user, GCUBEScope scope, GCUBESecurityManager ... securityManager) throws NoServiceFoundException, Exception {
        return CodelistImportCall.getCodelistImportManagerPortType(scope, securityManager).getCLImportItem(new CodelistIdentifier(id, user));
    }

    public CodelistImportCall(String user, String id, GCUBEScope scope, GCUBESecurityManager ... securityManager) throws NoServiceFoundException, Exception {
        this.user = user;
        this.id = id;
        this.cachedPT = CodelistImportCall.getCodelistImportManagerPortType(scope, securityManager);
    }

    public ImportStatusResponse getStatus() throws Exception {
        return this.cachedPT.getImportStatus(new CodelistIdentifier(this.id, this.user));
    }

    public String getDataAsJson(Limit limit) throws Exception {
        return this.cachedPT.getDataAsJson(new DataAsJsonRequest(new CodelistIdentifier(this.id, this.user), limit, null));
    }

    public List<CodelistColumnDefinition> getColumnsDefinition() throws Exception {
        ArrayList<CodelistColumnDefinition> toReturn = new ArrayList<CodelistColumnDefinition>();
        CodelistColumnDefinition[] codelistColumnDefinitionArray = this.cachedPT.getColumnsDefinition(new CodelistIdentifier(this.id, this.user)).getDefinition();
        int n = codelistColumnDefinitionArray.length;
        int n2 = 0;
        while (n2 < n) {
            CodelistColumnDefinition cdef = codelistColumnDefinitionArray[n2];
            toReturn.add(cdef);
            ++n2;
        }
        return toReturn;
    }

    public void remove() throws Exception {
        this.cachedPT.remove(new CodelistIdentifier(this.id, this.user));
    }
}

