/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.protocol;

import java.io.IOException;
import java.io.InputStream;
import java.rmi.RemoteException;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.FileTransferParameters;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.InfoObjectDescription;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.SMSPortType1PortType;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.StorageHint;

public class SMSInputStream
extends InputStream {
    protected Logger logger = Logger.getLogger(SMSInputStream.class);
    protected static final int chunkSize = 0x100000;
    protected byte[] buffer = new byte[0];
    protected int bufferPos = 0;
    protected SMSPortType1PortType sms;
    protected String oid;
    protected long startOffset = 0L;
    protected boolean eof = false;
    protected boolean preEof = false;

    public SMSInputStream(SMSPortType1PortType sms, String oid) {
        this.sms = sms;
        this.oid = oid;
        this.logger.setLevel(Level.ALL);
    }

    @Override
    public int read() throws IOException {
        if (this.bufferPos >= this.buffer.length) {
            this.fillBuffer();
        }
        if (this.eof) {
            return -1;
        }
        return this.buffer[this.bufferPos++] & 0xFF;
    }

    protected void fillBuffer() throws IOException {
        if (this.preEof) {
            this.eof = true;
            return;
        }
        boolean exit = false;
        int errors = 0;
        Throwable lastException = null;
        while (!exit) {
            try {
                this.logger.trace((Object)("getting chunk oid: " + this.oid + ", startOffset: " + this.startOffset + ", chunkSize: " + 0x100000));
                byte[] buffer = this.getChunk(this.sms, this.oid, this.startOffset, 0x100000L);
                this.logger.trace((Object)("Retrieved " + buffer.length + " bytes"));
                if (buffer.length == 0) {
                    this.eof = true;
                    return;
                }
                if (buffer.length < 0x100000) {
                    this.preEof = true;
                }
                this.buffer = buffer;
                this.bufferPos = 0;
                this.startOffset += 0x100000L;
                exit = true;
            }
            catch (Throwable e) {
                this.logger.error((Object)"Error during chunk retrieving", e);
                ++errors;
                lastException = e;
            }
            if (errors <= 10) continue;
            this.logger.error((Object)"Number of error exceeded limit");
            throw new IOException("Too many error getting the chunk", lastException);
        }
    }

    protected byte[] getChunk(SMSPortType1PortType sms, String oid, long startOffset, long offsetLength) throws RemoteException {
        StorageHint[] hints = new StorageHint[]{new StorageHint("start-reading-at-byte-position", String.valueOf(startOffset)), new StorageHint("read-at-most-bytes", String.valueOf(offsetLength))};
        String targetLocation = "inmessage://";
        FileTransferParameters parameters = new FileTransferParameters();
        parameters.setObjectID(oid);
        parameters.setFileLocation(targetLocation);
        parameters.setStorageHints(hints);
        InfoObjectDescription io = sms.getInfoObject(parameters);
        byte[] rawcontent = io.getRawContent();
        if (rawcontent == null) {
            rawcontent = new byte[]{};
        }
        return rawcontent;
    }
}

